/* Copyright (c) 2016-2018 VMware, Inc. All rights reserved. */
package com.vmware.automatic.plugin.registration.services;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;

/**
 * Trust manager that does not validate certificate chains.
 */
public class TrustAllTrustManager {

   /**
    * Creates a trustManager that does not validate certificate chains and hostname
    */
   public void trustAll() {
      try {
         // All-trusting hostname verifier
         HostnameVerifier allHostsTrusted = new HostnameVerifier() {
            public boolean verify(String urlHostName, SSLSession session) {
               return true;
            }
         };
         HttpsURLConnection.setDefaultHostnameVerifier(allHostsTrusted);

         SSLContext sc = SSLContext.getInstance("SSL");
         SSLSessionContext sslsc = sc.getServerSessionContext();
         sslsc.setSessionTimeout(0);
         sc.init(null, getAllTrustingTrustManager(), null);
         HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
      } catch (NoSuchAlgorithmException | KeyManagementException e) {
         System.out.println("Error while creating SSLContext");
         throw new RuntimeException(e);
      }
   }

   private TrustManager[] getAllTrustingTrustManager() {
      return new TrustManager[] { new X509TrustManager() {
         @Override
         public void checkClientTrusted(X509Certificate[] x509Certificates,
               String s) {
         }

         @Override
         public void checkServerTrusted(X509Certificate[] x509Certificates,
               String s) {
         }

         @Override
         public X509Certificate[] getAcceptedIssuers() {
            return null;
         }
      } };
   }
}
